/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.util;

import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class CacheManagementFilter
implements Filter {
    public static final String TRACE_MASKT = "SFILSCFT";
    public static final String TRACE_MASKF = "SFILSCFF";

    public void init(FilterConfig config) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            chain.doFilter(request, (ServletResponse)new WrappedResponse((HttpServletResponse)response));
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    class WrappedResponse
    extends HttpServletResponseWrapper {
        boolean cacheBehaviorComitted = false;

        WrappedResponse(HttpServletResponse response) {
            super(response);
        }

        private void assertCachingBehavior() {
            if (!this.cacheBehaviorComitted && !this.isCommitted()) {
                Trace.trace(CacheManagementFilter.TRACE_MASKT, "CacheManagementFilter checking for 'caching' tags....");
                this.cacheBehaviorComitted = true;
                if (!(this.containsHeader("Expires") || this.containsHeader("ETag") || this.containsHeader("Cache-Control"))) {
                    Trace.trace(CacheManagementFilter.TRACE_MASKT, "CacheManagementFilter found none, declaring 'NO CACHE'");
                    this.setHeader("Expires", "0");
                    this.setHeader("Cache-Control", "no-cache");
                } else {
                    Trace.trace(CacheManagementFilter.TRACE_MASKT, "CacheManagementFilter found some, not touching Expires:" + this.containsHeader("Expires") + " ETag:" + this.containsHeader("ETag") + " Cache-Control:" + this.containsHeader("Cache-Control"));
                }
            }
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return new WrappedServletOutputStream(super.getOutputStream());
        }

        public PrintWriter getWriter() throws IOException {
            return new WrappedPrintWriter(super.getWriter());
        }

        class WrappedPrintWriter
        extends PrintWriter {
            WrappedPrintWriter(PrintWriter printWriter) {
                super(printWriter);
            }

            public void write(int c) {
                WrappedResponse.this.assertCachingBehavior();
                super.write(c);
            }

            public void close() {
                WrappedResponse.this.assertCachingBehavior();
                super.close();
            }

            public boolean checkError() {
                WrappedResponse.this.assertCachingBehavior();
                return super.checkError();
            }

            public void write(String s, int off, int len) {
                WrappedResponse.this.assertCachingBehavior();
                super.write(s, off, len);
            }

            public void write(String s) {
                WrappedResponse.this.assertCachingBehavior();
                super.write(s);
            }

            public void write(char[] buf, int off, int len) {
                WrappedResponse.this.assertCachingBehavior();
                super.write(buf, off, len);
            }

            public void write(char[] buf) {
                WrappedResponse.this.assertCachingBehavior();
                super.write(buf);
            }

            public void print(char c) {
                WrappedResponse.this.assertCachingBehavior();
                super.print(c);
            }

            public void print(int i) {
                WrappedResponse.this.assertCachingBehavior();
                super.print(i);
            }

            public void print(boolean b) {
                WrappedResponse.this.assertCachingBehavior();
                super.print(b);
            }

            public void print(double d) {
                WrappedResponse.this.assertCachingBehavior();
                super.print(d);
            }

            public void println() {
                WrappedResponse.this.assertCachingBehavior();
                super.println();
            }

            public void print(char[] s) {
                WrappedResponse.this.assertCachingBehavior();
                super.print(s);
            }

            public void print(long l) {
                WrappedResponse.this.assertCachingBehavior();
                super.print(l);
            }

            public void print(float f) {
                WrappedResponse.this.assertCachingBehavior();
                super.print(f);
            }

            public void println(long x) {
                WrappedResponse.this.assertCachingBehavior();
                super.println(x);
            }

            public void println(boolean x) {
                WrappedResponse.this.assertCachingBehavior();
                super.println(x);
            }

            public void println(float x) {
                WrappedResponse.this.assertCachingBehavior();
                super.println(x);
            }

            public void println(char x) {
                WrappedResponse.this.assertCachingBehavior();
                super.println(x);
            }

            public void println(int x) {
                WrappedResponse.this.assertCachingBehavior();
                super.println(x);
            }

            public void println(double x) {
                WrappedResponse.this.assertCachingBehavior();
                super.println(x);
            }

            public void println(char[] x) {
                WrappedResponse.this.assertCachingBehavior();
                super.println(x);
            }
        }

        class WrappedServletOutputStream
        extends ServletOutputStream {
            private ServletOutputStream servletOutputStream;

            WrappedServletOutputStream(ServletOutputStream servletOutputStream) {
                this.servletOutputStream = servletOutputStream;
            }

            public void print(String s) throws IOException {
                WrappedResponse.this.assertCachingBehavior();
                this.servletOutputStream.print(s);
            }

            public void println(String s) throws IOException {
                WrappedResponse.this.assertCachingBehavior();
                this.servletOutputStream.println(s);
            }

            public void print(boolean b) throws IOException {
                WrappedResponse.this.assertCachingBehavior();
                this.servletOutputStream.print(b);
            }

            public void print(float f) throws IOException {
                WrappedResponse.this.assertCachingBehavior();
                this.servletOutputStream.print(f);
            }

            public void print(char c) throws IOException {
                WrappedResponse.this.assertCachingBehavior();
                this.servletOutputStream.print(c);
            }

            public void print(int i) throws IOException {
                WrappedResponse.this.assertCachingBehavior();
                this.servletOutputStream.print(i);
            }

            public void print(double d) throws IOException {
                WrappedResponse.this.assertCachingBehavior();
                this.servletOutputStream.print(d);
            }

            public void println() throws IOException {
                WrappedResponse.this.assertCachingBehavior();
                this.servletOutputStream.println();
            }

            public void println(boolean b) throws IOException {
                WrappedResponse.this.assertCachingBehavior();
                this.servletOutputStream.println(b);
            }

            public void println(char c) throws IOException {
                WrappedResponse.this.assertCachingBehavior();
                this.servletOutputStream.println(c);
            }

            public void println(int i) throws IOException {
                WrappedResponse.this.assertCachingBehavior();
                this.servletOutputStream.println(i);
            }

            public void println(float f) throws IOException {
                WrappedResponse.this.assertCachingBehavior();
                this.servletOutputStream.println(f);
            }

            public void println(double d) throws IOException {
                WrappedResponse.this.assertCachingBehavior();
                this.servletOutputStream.println(d);
            }

            public void write(int b) throws IOException {
                WrappedResponse.this.assertCachingBehavior();
                this.servletOutputStream.write(b);
            }

            public void close() throws IOException {
                WrappedResponse.this.assertCachingBehavior();
                this.servletOutputStream.close();
            }

            public void write(byte[] b) throws IOException {
                WrappedResponse.this.assertCachingBehavior();
                this.servletOutputStream.write(b);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                WrappedResponse.this.assertCachingBehavior();
                this.servletOutputStream.write(b, off, len);
            }

            public void flush() throws IOException {
                WrappedResponse.this.assertCachingBehavior();
                this.servletOutputStream.flush();
            }
        }
    }
}

